--
-- Use:
--     db2 -td";" -vf create.sql 
--
--
--


DROP TABLE URL;

CREATE TABLE URL (
	"REC_ID" INTEGER  NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 0,INCREMENT BY 1, NO CACHE), 
	"STATUS" INTEGER  NOT NULL  WITH DEFAULT 0, 
	"URL" CHARACTER (128)  NOT NULL  WITH DEFAULT , 
	"CONTENT_TYPE" CHARACTER (48)  NOT NULL  WITH DEFAULT , 
	"TITLE" CHARACTER (128)  NOT NULL  WITH DEFAULT , 
	"TXT" CHARACTER (254)  NOT NULL  WITH DEFAULT , 
	"DOCSIZE" INTEGER  NOT NULL  WITH DEFAULT 0, 
	"NEXT_INDEX_TIME" INTEGER  NOT NULL  WITH DEFAULT 0, 
	"LAST_MOD_TIME" INTEGER  NOT NULL  WITH DEFAULT 0, 
	"REFERRER" INTEGER  NOT NULL  WITH DEFAULT 0, 
	"TAG" CHARACTER (11)  NOT NULL  WITH DEFAULT , 
	"HOPS" INTEGER  NOT NULL  WITH DEFAULT 0, 
	"CATEGORY" CHARACTER (11)  NOT NULL  WITH DEFAULT ,
	"KEYWORDS" CHARACTER (254)  NOT NULL  WITH DEFAULT , 
	"DESCRIPTION" CHARACTER (100)  NOT NULL  WITH DEFAULT ,
	"CRC32" INTEGER  NOT NULL  WITH DEFAULT 0,
	"LANG" CHARACTER (2)  NOT NULL  WITH DEFAULT ,
	"CHARSET" CHARACTER(48) NOT NULL WITH DEFAULT ,
	"SEED" INTEGER NOT NULL WITH DEFAULT 0,
	PRIMARY KEY (REC_ID)  )  
DATA CAPTURE NONE;
CREATE UNIQUE INDEX URL_URL ON URL (URL ASC) PCTFREE 10 MINPCTUSED 10;
CREATE INDEX URL_CRC32 ON URL (CRC32 ASC) PCTFREE 10 MINPCTUSED 10;
CREATE INDEX URL_SEED ON URL (SEED ASC) PCTFREE 10 MINPCTUSED 10;

DROP TABLE DICT;
CREATE TABLE DICT (
	"URL_ID" INTEGER NOT NULL,
	"WORD" VARCHAR (32) NOT NULL,
	"INTAG" INTEGER NOT NULL )
DATA CAPTURE NONE;
CREATE INDEX DICT_URL_ID ON DICT (URL_ID ASC) PCTFREE 10 MINPCTUSED 10;
CREATE INDEX DICT_WORD ON DICT (WORD ASC) PCTFREE 10 MINPCTUSED 10;

DROP TABLE ROBOTS;
CREATE TABLE ROBOTS (
	"HOSTINFO" VARCHAR (127) NOT NULL,
	"PATH" VARCHAR (127) NOT NULL )
DATA CAPTURE NONE;

DROP TABLE STOPWORD;
CREATE TABLE STOPWORD (
	"WORD" CHARACTER (32) NOT NULL,
	"LANG" CHARACTER (2)  NOT NULL WITH DEFAULT ,
 	 PRIMARY KEY (WORD, LANG)
)
DATA CAPTURE NONE;
